/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.debug.breakpoints;

import frc.emul.debug.breakpoints.TemporaryBreakpoint;
import frc.emul.debug.events.CyclesBreakpointEvent;
import frc.emul.debug.events.ICyclesBreakpointListener;
import frc.emul.vectrex.Vectrex;
import java.util.ArrayList;
import java.util.List;

public class CyclesBreakpoint
extends TemporaryBreakpoint {
    public static final int FRAME_STOP_ADDRESS = 61852;
    public static final int FRAME_START_ADDRESS = 61858;
    private final List<ICyclesBreakpointListener> ears = new ArrayList<ICyclesBreakpointListener>();
    private long startStamp;
    private boolean started;
    private int startPC;
    private int stopPC;

    public CyclesBreakpoint() {
        this(61852, 61858);
    }

    public CyclesBreakpoint(int n, int n2) {
        this.setStopAddress(n);
        this.setStartAddress(n2);
    }

    public void removeFrameListener(ICyclesBreakpointListener iCyclesBreakpointListener) {
        this.ears.remove(iCyclesBreakpointListener);
    }

    public void addFrameListener(ICyclesBreakpointListener iCyclesBreakpointListener) {
        this.ears.add(iCyclesBreakpointListener);
    }

    public void setStartAddress(int n) {
        this.startPC = n;
        this.started = false;
    }

    public void setStopAddress(int n) {
        this.stopPC = n;
    }

    public int getStartAddress() {
        return this.startPC;
    }

    public int getStopAddress() {
        return this.stopPC;
    }

    public boolean evaluate(Vectrex vectrex) {
        int n;
        CyclesBreakpointEvent cyclesBreakpointEvent;
        int n2 = vectrex.getCPU().getCurrentPC();
        if (n2 == this.stopPC && this.started) {
            this.started = false;
            cyclesBreakpointEvent = new CyclesBreakpointEvent(this, this.startStamp, vectrex.getCPU().getCycles());
            n = this.ears.size();
            while (n-- > 0) {
                this.ears.get(n).cycleCountEnded(cyclesBreakpointEvent);
            }
        }
        if (n2 == this.startPC) {
            this.started = true;
            this.startStamp = vectrex.getCPU().getCycles();
            cyclesBreakpointEvent = new CyclesBreakpointEvent(this, this.startStamp);
            n = this.ears.size();
            while (n-- > 0) {
                this.ears.get(n).cycleCountStarted(cyclesBreakpointEvent);
            }
        }
        return false;
    }
}

